<%@ Page Title="Interpretation & Follow Up" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="BioLabInterpretation.aspx.cs" 
    Inherits="VIRP_WEB.Custom.EFR.BioLabInterpretation" MaintainScrollPositionOnPostback="true" %>

<%@ Register src="~/Controls/Custom/EFR/BioLabResultUserControl.ascx" tagname="BioLabResultUserControl" tagprefix="uc1" %>
<%@ Register src="~/Controls/Custom/EFR/LabResultInterpretation.ascx" tagname="LabResultInterpretation" tagprefix="uc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <script src="<%: ResolveUrl("~/Scripts/Custom/EFR/date.js") %>"></script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <link href="<%: ResolveUrl("~/Content/Custom/EFR/EFR_Legacy_Modified.css") %>" rel="stylesheet" />

    <style type="text/css">
        .style1
        {
            width: 25%;
        }
        .one fieldset 
        {                  
            background-color: #fefbd2;                          
            position : relative;
            margin-top:1em;
            padding-top:.75em;                
        }
        .one fieldset legend 
        {   
            position: absolute;
            top: -.5em;
            left: .5em;
        }
        .two fieldset 
        {
            background-color: #FFFFFF;            
            position : relative;            
            margin-top:1em;
            padding-top:.75em;
                          
        }
        .two fieldset legend
        {
            position: absolute;
            top: -.5em;
            left: .5em;           
        }
    </style>
    
    <script type = "text/javascript">
         $(document).ready(function() {

             $('div[id*=PanelTests]').each(function() {
                 if ($(this).find('span[id*=LabelTestName]').text() != "STANDARDIZED") {
                     $(this).removeClass("one").addClass("two");
                 }
                 else {
                     $(this).removeClass("two").addClass("one");
                 }

             });

             $("input[id*='TextBoxTEFSCReferenceRange']").each(function() {

                 var theValidator = $(this).closest('tr').find("[id*=ReferenceRangeListRequiredValidator]")[0];

                 if ($(this).val() === "") {
                     ValidatorEnable(theValidator, false);
                 }
             });

             $("input[id*='TextBoxTEFSCReferenceRange']").blur(function() {

                 var theValidator = $(this).closest('tr').find("[id*=ReferenceRangeListRequiredValidator]")[0];

                 if ($(this).val() != "") {
                 
                     ValidatorEnable(theValidator, true);
                     theValidator.isvalid = true;
                     ValidatorUpdateDisplay(theValidator);
                 }
                 else {

                     ValidatorEnable(theValidator, false);
                 }
             });

         });
    
   </script> 
    
    <asp:ValidationSummary ID="ValidationSummaryPatients"  runat="server"
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ValidationGroup="InterpretSaveComplete"
        ShowMessageBox="True" 
        ShowSummary="false"/>
        
    <uc1:BioLabResultUserControl ID="BioLabResultUserControl1" runat="server" LabReportDateIsReadOnly="true" />
    <br />
    <asp:Panel ID="Panel1" runat="server" Width="99%" GroupingText="Lab Tests">
        <table  summary="Table is used for layout purposes" width="70%">
            <tr>
                <td>
                    <asp:Label ID="Label2" SkinID="DataLabel" runat="server" 
                        AssociatedControlID="lblElapsedTime" Width="110px">Elapsed Time:</asp:Label>
                    <asp:Label ID="lblElapsedTime" SkinID="DataLabel" runat="server" /><asp:Label ID="Label4" SkinID="DataLabel" runat="server" Text=" hr"/>
                </td>
                <td >
                    <asp:Label ID="Label6" SkinID="DataLabel" runat="server" AssociatedControlID="lblTotalVol">Total Volume:</asp:Label>
                    <asp:Label ID="lblTotalVol" SkinID="DataLabel" runat="server" ></asp:Label><asp:Label ID="Label8" SkinID="DataLabel" runat="server" Text=" mL"/>
                </td>
                <td>
                    <asp:Label ID="Label9" SkinID="DataLabel" runat="server" AssociatedControlID="lblVolOfAnalyteTests">Volume of Analyte Tests:</asp:Label>
                    <asp:Label ID="lblVolOfAnalyteTests" SkinID="DataLabel" runat="server" /><asp:Label ID="Label10" SkinID="DataLabel" runat="server" Text=" mL"/>
                </td>
            </tr>
        </table>
         <asp:Repeater ID="RepeaterAnalyteList" runat="server" OnItemDataBound="RepeaterAnalyteList_ItemDataBound">
             <HeaderTemplate>
            </HeaderTemplate>
            <ItemTemplate>
                <%--<fieldset>--%>
                <asp:Panel runat = "server" ID = "PanelTests" GroupingText = "&nbsp;">
                <table width="100%"  cellspacing="-2" cellpadding="2" >
                    <tr>
                        <td>
                            <asp:HiddenField runat="server" ID="HiddenFieldAnalysisDetailId" Value='<%# Eval("ANALYSIS_DETAIL_ID")%>' />
                            <asp:Label ID="LabelforTestName" AssociatedControlID="LabelTestName" runat="server" SkinID = "DataLabel">Test Name:</asp:Label>
                            &nbsp;
                            <b>
                                <asp:Label ID="LabelTestName" runat="server" SkinID = "DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("TEST_NAME")))%>'></asp:Label>
                            </b>
                        </td>                        
                        <td>
                            <asp:Label ID="LabelforLabelAnalysisMethod" runat="server" SkinID = "DataLabel" Text="Analysis Method:&nbsp;"></asp:Label>
                            <asp:Label ID="LabelAnalysisMethod" runat="server" SkinID = "DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STD_ANALYSISMETHOD.NAME")))%>'></asp:Label>
                        </td>
                        <td colspan = "2">
                            <asp:Label ID="LabelforLabelAnalyteName" runat="server" SkinID = "DataLabel" Text="Analyte:&nbsp;"></asp:Label>
                            <b>
                                <asp:Label ID="LabelAnalyteName" runat="server" SkinID = "DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ANALYTE_NAME")))%>'></asp:Label>
                            </b>
                        </td>
                    </tr>
                    <tr>                       
                        <td colspan="2">&nbsp;</td>
                        <td colspan = "2">
                            <asp:Label ID="LabelforLabelResult" runat="server" SkinID = "DataLabel" Text="Result:&nbsp;"></asp:Label>
                            <asp:Label ID="LabelResult" runat="server" SkinID = "DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("RESULT_TEXT") + " " + Eval("STD_UNIT2.NAME")))%>'></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4">
                            <asp:Label ID="LabelCommentText" SkinID = "DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("EVAL_COMMENT_TEXT")))%>'></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td colspan = "2">
                            <asp:Label ID="LabelforLabelOtherCommentText" SkinID = "DataLabel" runat="server" Text="Comments:&nbsp;"></asp:Label>
                            <asp:Label ID="LabelOtherCommentText" SkinID = "DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("OTHER_COMMENT_TEXT")))%>'></asp:Label>
                        </td>
                         <td colspan = "2">
                            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxTEFSCReferenceRange" runat="server" AssociatedControlID="TextBoxTEFSCReferenceRange" Text="TEFSC Reference Range:"></asp:Label>
                            <asp:Label ID="LabelforLabelTEFSCReferenceRange" runat="server" SkinID="DataLabel" Text="TEFSC Reference Range:"></asp:Label>
                            
                            <asp:TextBox ID="TextBoxTEFSCReferenceRange" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("TEFSC_REFERENCE_RANGE")))%>'></asp:TextBox>
                            <asp:Label ID="LabelTEFSCReferenceRange" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("TEFSC_REFERENCE_RANGE")))%>'></asp:Label>
                            &nbsp;
                            <asp:Label SkinID="DataLabel" ID="LabelforDropDownListTEFSCReferenceRangeUnits" AssociatedControlID="DropDownListTEFSCReferenceRangeUnits" runat="server" Text="Unit:"></asp:Label>
                            <asp:Label ID="LabelforLabelTEFSCReferenceRangeUnits" SkinID="DataLabel" runat="server" Text="Unit:"></asp:Label>
        
                                <asp:DropDownList ID = "DropDownListTEFSCReferenceRangeUnits" runat = "server"
                                    AppendDataBoundItems="true" DataSourceID="ObjectDataSourceTestUnits" 
                                    DataTextField="Value" 
                                    DataValueField="Key">
                                    <asp:ListItem Value="" Text = "(Select Unit)">
                                    </asp:ListItem>
                                </asp:DropDownList>
                                <asp:RequiredFieldValidator ID="ReferenceRangeListRequiredValidator" runat="server" 
                                    ForeColor="Red" 
                                    Display="Dynamic" 
                                    EnableClientScript="true"  
                                    SetFocusOnError="true"                                                            
                                    ControlToValidate="DropDownListTEFSCReferenceRangeUnits"                                                                 
                                    InitialValue=""
                                    ValidationGroup = "InterpretSaveComplete"
                                    ErrorMessage="Unit is required when TEFSC Reference Range has data.">
                                    </asp:RequiredFieldValidator> 
                                <asp:Label ID="LabelTEFSCReferenceRangeUnits" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STD_UNIT1.NAME")))%>'></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <asp:Panel ID="PanelReferenceRange" runat="server" Width="100%" Height="100%" GroupingText="Lab Reference Range">
                                <asp:Label ID="LabelforLabelLabReferenceRange" runat="server" Text="Lab Reference Range:"></asp:Label>&nbsp;&nbsp;    
                                <asp:Label ID="LabelLabReferenceRange" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAB_REFERENCE_RANGE")))%>'></asp:Label>
                                <br />
                                <asp:Label ID="LabelforLabelResultReferenceUnit" runat="server" Text="Unit:"></asp:Label>&nbsp;&nbsp;   
                                <asp:Label ID="LabelResultReferenceUnit" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STD_UNIT.NAME")))%>'></asp:Label> 
                                <br />
                                <asp:Label ID="LabelforLabelLabAboveReferenceRange" runat="server" SkinID = "DataLabel" Text="Above Lab Reference Range:"></asp:Label>&nbsp;&nbsp;
                                <asp:Label ID="LabelLabAboveReferenceRange" runat="server" SkinID = "DataLabel" Text='<%# Eval("LAB_ABOVE_REFERENCE_RANGE") != null? Eval("LAB_ABOVE_REFERENCE_RANGE").ToString() == "1" ? "Yes" : "No": string.Empty%>'></asp:Label>
                            </asp:Panel>
                        </td>
                        <td colspan="2">
                            <asp:Panel ID="PanelAboveTEFSCReferenceRange" runat="server" Width="100%" Height="100%" GroupingText="Above TEFSC Reference Range &nbsp;&nbsp;">
                                <asp:RadioButtonList ID="RadioButtonListAboveTEFSCRefenceRange" runat="server" DataValueField="TEFSC_ABOVE_REFERENCE_RANGE">
                                    <asp:ListItem Value="1">Yes</asp:ListItem>
                                    <asp:ListItem Value="0">No</asp:ListItem>
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID = "RequiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange" 
                                    runat = "server" 
                                    ValidationGroup = "InterpretSaveComplete" 
                                    EnableClientScript = "true" 
                                    SetFocusOnError = "true" 
                                    Display = "Dynamic" 
                                    ControlToValidate = "RadioButtonListAboveTEFSCRefenceRange" 
                                    InitialValue = "" 
                                    ErrorMessage = "Above TEFSC Reference Range is required.">
                                </asp:RequiredFieldValidator> 
                            </asp:Panel>
                        </td>
                    </tr>
                </table>
                </asp:Panel>
                <%--</fieldset>--%>
            </ItemTemplate>
         </asp:Repeater>
    </asp:Panel>
    <br />
    
<uc2:LabResultInterpretation ID="LabResultInterpretation1" runat="server" ShowBioMonitoringFollowUpSection = "true" ShowFacilityBoxAndPCPVAMCPanels = "true"/>
<asp:Label SkinID="DataLabel" runat="server" ID="lblSaveConfirmation" Font-Bold="true" ForeColor="Red" Visible="false" Text="Save successful." Font-Size="Medium"></asp:Label>   
     
<asp:ObjectDataSource ID="ObjectDataSourceTestUnits" 
    runat="server" SelectMethod="GetActiveOrderedTestUnits" 
    TypeName="VIRP.EFR.BLL.STD_UNITSManager">
<SelectParameters>
    <asp:Parameter Name="CURRENT_USER" Type="String" />
    <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="String" />
</SelectParameters>
 </asp:ObjectDataSource>

</asp:Content>

